package data.scripts.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShieldAPI.ShieldType;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipAPI.HullSize;
import data.scripts.everyframe.SWP_BlockedHullmodDisplayScript;
import data.scripts.util.SWP_Util;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SWP_ShieldBypass extends BaseHullMod {

    public static final float FLUX_BONUS = 50f;

    private static final Set<String> BLOCKED_HULLMODS = new HashSet<>(7);

    static {
        BLOCKED_HULLMODS.add("frontshield");
        BLOCKED_HULLMODS.add("frontemitter");
        BLOCKED_HULLMODS.add("adaptiveshields");
        BLOCKED_HULLMODS.add("stabilizedshieldemitter");
        BLOCKED_HULLMODS.add("hardenedshieldemitter");
        BLOCKED_HULLMODS.add("advancedshieldemitter");
        BLOCKED_HULLMODS.add("extendedshieldemitter");
    }

    @Override
    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        Collection<String> builtIn = SWP_Util.getBuiltInHullMods(ship);
        for (String tmp : BLOCKED_HULLMODS) {
            if (ship.getVariant().getHullMods().contains(tmp) && !builtIn.contains(tmp)) {
                ship.getVariant().removeMod(tmp);
                SWP_BlockedHullmodDisplayScript.showBlocked(ship);
            }
        }

        ship.setShield(ShieldType.NONE, 0f, 0f, 90f);
    }

    @Override
    public void applyEffectsBeforeShipCreation(HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getShieldDamageTakenMult().modifyMult(id, 0f);
        stats.getShieldUpkeepMult().modifyMult(id, 0f);
        stats.getFluxDissipation().modifyPercent(id, FLUX_BONUS);
    }

    @Override
    public String getDescriptionParam(int index, HullSize hullSize) {
        if (index == 0) {
            return "" + (int) FLUX_BONUS;
        }
        return null;
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        if (ship == null || ship.getShield() == null) {
            return "Ship has no shields";
        }

        Collection<String> builtIn = SWP_Util.getBuiltInHullMods(ship);
        if (ship.getVariant().hasHullMod("frontshield")) {
            return "Incompatible with Front Shield Generator";
        }
        if (ship.getVariant().hasHullMod("frontemitter") && !builtIn.contains("frontemitter")) {
            return "Incompatible with Front Shield Emitter";
        }
        if (ship.getVariant().hasHullMod("adaptiveshields") && !builtIn.contains("adaptiveshields")) {
            return "Incompatible with Omni Shield Emitter";
        }
        if (ship.getVariant().hasHullMod("stabilizedshieldemitter") && !builtIn.contains("stabilizedshieldemitter")) {
            return "Incompatible with Stabilized Shields";
        }
        if (ship.getVariant().hasHullMod("hardenedshieldemitter") && !builtIn.contains("hardenedshieldemitter")) {
            return "Incompatible with Hardened Shields";
        }
        if (ship.getVariant().hasHullMod("advancedshieldemitter") && !builtIn.contains("advancedshieldemitter")) {
            return "Incompatible with Accelerated Shields";
        }
        if (ship.getVariant().hasHullMod("extendedshieldemitter") && !builtIn.contains("extendedshieldemitter")) {
            return "Incompatible with Extended Shields";
        }

        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        Collection<String> builtIn = SWP_Util.getBuiltInHullMods(ship);

        return ship != null && (ship.getHullSpec().getDefenseType() == ShieldType.FRONT ||
                                ship.getHullSpec().getDefenseType() == ShieldType.OMNI) &&
                !(ship.getHullSpec().getDefenseType() == ShieldType.NONE) &&
                !ship.getVariant().getHullMods().contains("frontshield") &&
                (!ship.getVariant().getHullMods().contains("frontemitter") ||
                 builtIn.contains("frontemitter")) &&
                (!ship.getVariant().getHullMods().contains("adaptiveshields") ||
                 builtIn.contains("adaptiveshields")) &&
                (!ship.getVariant().getHullMods().contains("stabilizedshieldemitter") ||
                 builtIn.contains("stabilizedshieldemitter")) &&
                (!ship.getVariant().getHullMods().contains("hardenedshieldemitter") ||
                 builtIn.contains("hardenedshieldemitter")) &&
                (!ship.getVariant().getHullMods().contains("advancedshieldemitter") ||
                 builtIn.contains("advancedshieldemitter")) &&
                (!ship.getVariant().getHullMods().contains("extendedshieldemitter") ||
                 builtIn.contains("extendedshieldemitter"));
    }
}
